* Encoding: UTF-8.

*===================================================================================*
* TTULO DE LA SINTAXIS:*
* Nmero de Lesionados por cada 100 siniestros de trnsito*
* OPERACIN ESTADSTICA:*
* Anuario de Transporte 2018 - Siniestros de Trnsito*
*DIRECCIN TCNICA RESPONSABLE:*
* Direccin de Estadsticas Econmicas (DECON)*
* ENTIDAD EJECUTORA:*
* Instituto Nacional de Estadstica y Censos (INEC)*
*===================================================================================*
* Fecha de elaboracin:        11 de Diciembre del 2018*
* Fecha ltima modificacin:  05 de Septiembre del 2019*
*===================================================================================*
* Elaborado por:*
* Unidad de Gestin de Estadsticas Estructurales (GESE)*.
* Franklin Tenesaca N.
* Gabriela Hidalgo.

*Instrucciones:.
*1.- Descarga la base de datos de Siniestros de Trnsito "2018_SINIESTROS_DE_TRANSITO_BDD" en formato SPSS de la pgina web del INEC (http://www.ecuadorencifras.gob.ec//transporte/).
*2.- Guardar y abrir la base de datos "2018_SINIESTROS_DE_TRANSITO_BDD".

DATASET NAME SINIESTROS.
DATASET COPY SINIESTROS.
DATASET  ACTIVATE SINIESTROS.

**********************************************************************************************************************.
***********NMERO DE LESIONADOS POR CADA 100 SINIESTROS DE TRNSITO - PROVINCIAL***.
**********************************************************************************************************************.

***Creando variable nmero de siniestros***.
COMPUTE NST=1.
FORMATS NST (F5.0).
VARIABLE LABELS NST 'Nmero de siniestros'.
EXECUTE.

***Agregando la base de datos a nivel de provincia***.
DATASET DECLARE TASA_LESIONADOS.
AGGREGATE
  /outfile='TASA_LESIONADOS'
  /break=PROVINCIA
  /NST=SUM(NST)
  /NUM_LESIONADO=SUM(NUM_LESIONADO).

**Utilizacin de la base de datos agregada***.
DATASET  ACTIVATE TASA_LESIONADOS.

***Preparando la base para el clculo del indicador***.
VARIABLE LABELS NST 'Nmero de siniestros de trnsito'.
FORMATS NST (F10.0).
EXECUTE.

VARIABLE LABELS NUM_LESIONADO 'Nmero de lesionados'.
FORMATS NUM_LESIONADO (F10.0).
EXECUTE.

COMPUTE TLS=(NUM_LESIONADO/(NST/100)).
VARIABLE LABELS TLS 'Nmero de lesionados por cada 100 siniestros de trnsito'.
FORMATS TLS (F5.0).
EXECUTE.

****CUADRO N 23****.

***Tabulado: Nmero de lesionados por cada 100 siniestros de trnsito - Provincias***.
TABLES
/OBSERVATION= NUM_LESIONADO NST TLS
/TABLE= PROVINCIA BY NUM_LESIONADO + NST + TLS
/STATISTICS=SUM
/TITLE='INDICADORES Siniestros DE TRNSITO, ao 2018'
           'POR PROVINCIA'
           '(Nmero)'
/CAPTION='Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
                 'Fuente: Agencia Nacional de Trnsito - ANT 2018'.
EXECUTE.

**********************************************************************************************************************.
************NMERO DE LESIONADOS POR CADA 100 SINIESTROS DE TRNSITO - NACIONAL***.
**********************************************************************************************************************.

*Usando base de datos "2018_SINIESTROS_DE_TRANSITO_BDD"**.
DATASET ACTIVATE TASA_LESIONADOS.

COMPUTE TOTAL=1.
VARIABLE LABELS TOTAL 'Nacional'.
VALUE LABELS TOTAL 1'NACIONAL'.
FORMATS TOTAL (F10.0).
EXECUTE.

***Agregando la base de datos a nivel nacional***.
DATASET DECLARE TASA_LESIONADOS_N.
AGGREGATE
  /outfile='TASA_LESIONADOS_N'
  /break=TOTAL
  /NST=SUM(NST)
  /NUM_LESIONADO=SUM(NUM_LESIONADO).

**Utilizacin de la base de datos agregada***.
DATASET ACTIVATE TASA_LESIONADOS_N.

VARIABLE LABELS NST 'Nmero de siniestros de trnsito'.
FORMATS NST (F10.0).
EXECUTE.

VARIABLE LABELS NUM_LESIONADO 'Nmero de lesionados'.
FORMATS NUM_LESIONADO (F10.0).
EXECUTE.

COMPUTE TLS=(NUM_LESIONADO/(NST/100)).
VARIABLE LABELS TLS 'Nmero de lesionados por cada 100 siniestros de trnsito'.
FORMATS TLS (F5.0).
EXECUTE.

****CUADRO N 23****.

***Tabulado: Nmero de lesionados por cada 100 siniestros de trnsito - Nacional***.

TABLES
/OBSERVATION= NUM_LESIONADO NST TLS
/TABLE= TOTAL BY NUM_LESIONADO + NST + TLS
/STATISTICS=SUM
/TITLE='INDICADORES SINIESTROS DE TRNSITO, ao 2018'
           'POR PROVINCIA'
           '(Nmero)'
/CAPTION='Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
                 'Fuente: Agencia Nacional de Trnsito - ANT 2018'.
EXECUTE.


DATASET ACTIVATE SINIESTROS. 
DATASET CLOSE TASA_LESIONADOS_N.
DATASET ACTIVATE SINIESTROS. 
DATASET CLOSE TASA_LESIONADOS.








